
; Water Tank Level Meter receiver  

	ERRORLEVEL -302
	ERRORLEVEL -306

	list P=16F88
	#include p16f88.inc

;Program Configuration Register 1
		__CONFIG    _CONFIG1, _CP_ALL & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_IO

;Program Configuration Register 2
		__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

; EEPROM locations
EEPROM1		equ	H'00'	; non-volatile storage for tank selection 0-7
EEPROM2		equ	H'01'	; non volatile storage for tank selection 8 & 9
EEPROM3		equ	H'02'	; non-volatile storage for pump on selection 0-7
EEPROM4		equ	H'03'	; non volatile storage for pump on selection 8 & 9
; level set do not change the 0...9 order
EEPROM5		equ	H'04'	; level setting for tank0
EEPROM6		equ	H'05'	; level setting for tank1
EEPROM7		equ	H'06'	; level setting for tank2
EEPROM8		equ	H'07'	; level setting for tank3
EEPROM9		equ	H'08'	; level setting for tank4
EEPROM10	equ	H'09'	; level setting for tank5
EEPROM11	equ	H'0A'	; level setting for tank6
EEPROM12	equ	H'0B'	; level setting for tank7
EEPROM13	equ	H'0C'	; level setting for tank8
EEPROM14	equ	H'0D'	; level setting for tank9
; temperature set do not change the 0...9 order
EEPROM15	equ	H'0E'	; temperature setting for tank0
EEPROM16	equ	H'0F'	; temperature setting for tank1
EEPROM17	equ	H'10'	; temperature setting for tank2
EEPROM18	equ	H'11'	; temperature setting for tank3
EEPROM19	equ	H'12'	; temperature setting for tank4
EEPROM20	equ	H'13'	; temperature setting for tank5
EEPROM21	equ	H'14'	; temperature setting for tank6
EEPROM22	equ	H'15'	; temperature setting for tank7
EEPROM23	equ	H'16'	; temperature setting for tank8
EEPROM24	equ	H'17'	; temperature setting for tank9
; display mode storage
EEPROM25	equ	H'18'	; mode storage
	
; bank 0 RAM 
TIMEOUTH		equ	H'20'	; timeout counter ms byte
TIMEOUTL		equ	H'21'	; timeout counter ms byte
TIMEOUT_FLG		equ	H'22'	; timeout flag
OUT_FLAG		equ	H'23'	; tank "out" flag
DEC_FLAG		equ	H'24'	; decreasing flag (set when using down switch)
TANK_COUNT		equ	H'25'	; tank number count for selection check
ONOFF			equ	H'26'	; pump on or off flag	
TEMP1			equ	H'27'	; temporaty register
SW_FLAG			equ	H'28'	; switch closed flag
TANK_NUMBER		equ	H'29'	; tank number temorary register
BCD_0			equ	H'2A'	; MS bcd value
BCD_1			equ	H'2B'	; LS binary coded decimal value
BIN_0			equ	H'2C'	; 8-bit binary value
TEMP			equ	H'2D'	; data storage 
CNT_8			equ	H'2E'	; counter in BCD routine
OUT1			equ	H'2F'	; ASCII byte
OUT2			equ	H'30'	; ASCII byte
OUT3			equ	H'31'	; ASCII byte
TRANS_COUNT		equ	H'32'	; transmission counter	
STORE1			equ	H'33'	; delay counter	
STORE2			equ	H'34'	; delay counter
STORE3			equ	H'35'	; delay counter
D_STO			equ	H'36'	; data storage during LCD drive
PORTA_STO		equ	H'37'	; portA store during LCD data transfer
RECEIVE0		equ	H'38'	; received data
RECEIVE1		equ	H'39'	; received data
RECEIVE2		equ	H'3A'	; received data
RECEIVE3		equ	H'3B'	; received data
RECEIVE4		equ	H'3C'	; received data
RECEIVE5		equ	H'3D'	; received data
TIMER1L_WK		equ	H'3E'	; timer 1 ls byte working register
TIMER1H_WK		equ	H'3F'	; timer 1 ms byte working register
TIMER1L_VAL		equ	H'40'	; timer 1 ls byte working register
TIMER1H_VAL		equ	H'41'	; timer 1 ms byte working register
TIMER1L_2		equ	H'42'	; timer 1 /2 ls byte working register
TIMER1H_2		equ	H'43'	; timer 1 /2 lm byte working register
FLAG			equ	H'44'   ; interrupt flag
COUNT_BITS		equ	H'45'	; data count bits
ENCODE			equ	H'46'	; encode value
MODE			equ	H'47'	; display mode
TANK_SHOW		equ	H'48'	; displayed tank
RECEIVEX		equ	H'49'	; stop bits

; tank level values. Do not change addresses or order as used in the software
TANK0			equ	H'4A'	; tank 0 level
TANK1			equ	H'4B'	; tank 0 level	
TANK2			equ	H'4C'	; tank 0 level	
TANK3			equ	H'4D'	; tank 0 level	
TANK4			equ	H'4E'	; tank 0 level	
TANK5			equ	H'4F'	; tank 0 level	
TANK6			equ	H'50'	; tank 0 level	
TANK7			equ	H'51'	; tank 0 level	
TANK8			equ	H'52'	; tank 0 level	
TANK9			equ	H'53'	; tank 0 level
; cell level values. Do not change addresses or order as used in the software
CELL0			equ	H'54'	; cell V tank 0	
CELL1			equ	H'55'	; cell V tank 1	
CELL2			equ	H'56'	; cell V tank 2	
CELL3			equ	H'57'	; cell V tank 3	
CELL4			equ	H'58'	; cell V tank 4	
CELL5			equ	H'59'	; cell V tank 5	
CELL6			equ	H'5A'	; cell V tank 6	
CELL7			equ	H'5B'	; cell V tank 7
CELL8			equ	H'5C'	; cell V tank 8	
CELL9			equ	H'5D'	; cell V tank 9
; temperature values. Do not change addresses or order as used in the software
TEMPC0			equ	H'5E'	; temperture tank 0	
TEMPC1			equ	H'5F'	; temperture tank 1	
TEMPC2			equ	H'60'	; temperture tank 2	
TEMPC3			equ	H'61'	; temperture tank 3	
TEMPC4			equ	H'62'	; temperture tank 4	
TEMPC5			equ	H'63'	; temperture tank 5	
TEMPC6			equ	H'64'	; temperture tank 6	
TEMPC7			equ	H'65'	; temperture tank 7	
TEMPC8			equ	H'66'	; temperture tank 8	
TEMPC9			equ	H'67'	; temperture tank 9

TANK_ON_OFF_A	equ	H'68'	; tank on or off (0 to 7)
TANK_ON_OFF_B	equ	H'69'	; tank on or off (8 & 9)
PUMP_ON_OFF_A	equ	H'6A'	; pump on or off (0 to 7)
PUMP_ON_OFF_B	equ	H'6B'	; pump on or off (8 & 9)
		
; All Banks RAM

W_TMP			equ	H'70'	; storage of w before interrupt
STATUS_TMP		equ	H'71'	; status storage before interrupt
PCLATH_STO		equ	H'72'	; store PClath

; timeout counters. Do not change addresses or order as used in the software
TIMEOUT0		equ	H'76'	; timeout0
TIMEOUT1		equ	H'77'	; timeout1
TIMEOUT2		equ	H'78'	; timeout2
TIMEOUT3		equ	H'79'	; timeout3
TIMEOUT4		equ	H'7A'	; timeout4
TIMEOUT5		equ	H'7B'	; timeout5
TIMEOUT6		equ	H'7C'	; timeout6
TIMEOUT7		equ	H'7D'	; timeout7
TIMEOUT8		equ	H'7E'	; timeout8
TIMEOUT9		equ	H'7F'	; timeout9

; preprogram EEPROM DATA 
	
	ORG     H'2100'

	DE	B'00000010', B'00000000'; tank 1 selected
	DE	B'00000000', B'00000000'; pumps all off	
	DE	H'00', H'00', H'00', H'00', H'00', H'00', H'00', H'00', H'00', H'00' ; tank level pump off level
	DE	H'00', H'00', H'00', H'00', H'00', H'00', H'00', H'00', H'00', H'00' ; temperature pump off value
	DE	H'00' ; mode is standard display
; ******************************************************************

; start at memory 0

	org		0			; reset vector
	goto	MAIN		; byte 1
	org     4			; interrupt vector
; Interrupt
; start interrupt by saving w and status registers  
	movwf	W_TMP		; w to w_tmp storage
	swapf	STATUS,w	; status to w
	movwf	STATUS_TMP	; status in status_tmp 
	movf	PCLATH,w	; keep PCLATH
	movwf	PCLATH_STO	; store PC lath
; page and banks	
	bcf		STATUS,RP0	; select memory bank 
	bcf		STATUS,RP1	; select memory bank 0
	bsf		PCLATH,3	; page 1
	goto	TMER1_FLG	; continue at page 1 (no room at page 0)
	
; start of page 1
	org		H'800'		; page 1
TMER1_FLG
; preload timer
	bcf		T1CON,0		; timer 1 off	
	movf	TIMER1H_VAL,w
	addwf	TMR1H,f
	movf	TIMER1L_VAL,w
	addwf	TMR1L,f
	btfsc	STATUS,C
	incf	TMR1H,f		; increase ms byte if ls addition has carry
	bsf		T1CON,0		; timer 1 on
	bcf		PIR1,TMR1IF	; clear timer 1 overflow
	bsf		FLAG,0		; set flag bit to indicate an interrupt has occurred for data reception

; increase timers (~65.5s)
	incfsz	TIMEOUTL,f	; timeout counter ls byte
	goto	RECLAIM
	incfsz	TIMEOUTH,f	; timeout counter ms byte, when zero 65.536 seconds elapsed  between zeroes
	goto	RECLAIM

; each 65.536 seconds decrease timeout counters for each tank if selected
TIME0
	btfss	TANK_ON_OFF_A,0; if tank selected check timeout
	goto	TIME1
	movf	TIMEOUT0,w	; timeout0
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME0
	movlw	H'7F'
	movwf	TANK0
;	movwf	CELL0
	movwf	TEMPC0		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT0	; reset timer to 1 hour
DEC_TIME0
	decf	TIMEOUT0,f
TIME1
	btfss	TANK_ON_OFF_A,1; if tank selected check timeout
	goto	TIME2
	movf	TIMEOUT1,w	; timeout1
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME1
	movlw	H'7F'
	movwf	TANK1
;	movwf	CELL1
	movwf	TEMPC1		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT1	; reset timer to 1 hour
DEC_TIME1
	decf	TIMEOUT1,f
TIME2
	btfss	TANK_ON_OFF_A,2; if tank selected check timeout
	goto	TIME3
	movf	TIMEOUT2,w	; timeout2
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME2
	movlw	H'7F'
	movwf	TANK2
;	movwf	CELL2
	movwf	TEMPC2		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT2	; reset timer to 1 hour
DEC_TIME2
	decf	TIMEOUT2,f
TIME3
	btfss	TANK_ON_OFF_A,3; if tank selected check timeout
	goto	TIME4
	movf	TIMEOUT3,w	; timeout3
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME3
	movlw	H'7F'
	movwf	TANK3
;	movwf	CELL3
	movwf	TEMPC3		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT3	; reset timer to 1 hour
DEC_TIME3
	decf	TIMEOUT3,f
TIME4
	btfss	TANK_ON_OFF_A,4; if tank selected check timeout
	goto	TIME5
	movf	TIMEOUT4,w	; timeout4
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME4
	movlw	H'7F'
	movwf	TANK4
;	movwf	CELL4
	movwf	TEMPC4		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT4	; reset timer to 1 hour
DEC_TIME4
	decf	TIMEOUT4,f
TIME5
	btfss	TANK_ON_OFF_A,5; if tank selected check timeout
	goto	TIME6
	movf	TIMEOUT5,w	; timeout5
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME5
	movlw	H'7F'
	movwf	TANK5
;	movwf	CELL5
	movwf	TEMPC5		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT5	; reset timer to 1 hour
DEC_TIME5
	decf	TIMEOUT5,f
TIME6
	btfss	TANK_ON_OFF_A,6; if tank selected check timeout
	goto	TIME7
	movf	TIMEOUT6,w	; timeout6
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME6
	movlw	H'7F'
	movwf	TANK6
;	movwf	CELL6
	movwf	TEMPC6		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT6	; reset timer to 1 hour
DEC_TIME6
	decf	TIMEOUT6,f
TIME7
	btfss	TANK_ON_OFF_A,7; if tank selected check timeout
	goto	TIME8
	movf	TIMEOUT7,w	; timeout7
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME7
	movlw	H'7F'
	movwf	TANK7
;	movwf	CELL7
	movwf	TEMPC7		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT7	; reset timer to 1 hour
DEC_TIME7
	decf	TIMEOUT7,f
TIME8
	btfss	TANK_ON_OFF_B,0; if tank selected check timeout
	goto	TIME9
	movf	TIMEOUT8,w	; timeout8
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME8
	movlw	H'7F'
	movwf	TANK8
;	movwf	CELL8
	movwf	TEMPC8		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT8	; reset timer to 1 hour
DEC_TIME8
	decf	TIMEOUT8,f
TIME9
	btfss	TANK_ON_OFF_B,1; if tank selected check timeout
	goto	RECLAIM
	movf	TIMEOUT9,w	; timeout9
	btfss	STATUS,Z	; if zero load data for ? value
	goto	DEC_TIME9
	movlw	H'7F'
	movwf	TANK9
;	movwf	CELL9
	movwf	TEMPC9		; data at ? value because data not received in 1 hour
	bsf		TIMEOUT_FLG,0; set timeout flag so display updates
	movlw	D'56'
	movwf	TIMEOUT9	; reset timer to 1 hour
DEC_TIME9
	decf	TIMEOUT9,f

; end of interrupt restore status,w and pclath
RECLAIM
	movf	PCLATH_STO,w; restore PCLATH
	movwf	PCLATH
	swapf	STATUS_TMP,w; status temp storage to w
	movwf	STATUS		; w to status register
	swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
	swapf   W_TMP,w		; swap bits and into w register
	retfie				; return from interrupt

WRITE_ERR
	bcf		PCLATH,3	; page 0
	call	SPACE1
	movlw	A'E'		; write, error
	call	DRV_LCD
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'R'		; 
	call	DRV_LCD
	movlw	A'O'		; 
	call	DRV_LCD
	movlw	A'R'		; 
	call	DRV_LCD
	call	SPACE4
	call	SPACE2
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	movlw	A'E'		; write, enable a tank
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	movlw	A'A'		; 
	call	DRV_LCD
	movlw	A'B'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'A'		; 
	call	DRV_LCD
	call	SPACE1
	call	TANK_WORD	; write TANK
	movlw	A'!'
	call	DRV_LCD 
	call	SPACE4
	goto	CHECK_SWITCHES
	
;******************************************************************************************* 

; page 0
	org		H'0D'		; page 0	
MAIN
	bsf		STATUS,RP0	; select memory bank 1

; set inputs/outputs
	movlw	B'00000111'	; comparators off
	movwf	CMCON
	movlw	H'FF'		; port B inputs set 
	movwf	TRISB		; port B data direction register
	movlw	B'00100000'	; outputs (0) and inputs (1)
	movwf	TRISA		; port A data direction register
	movlw	B'00000111'	; settings (pullups enabled) timer 0/ 256
	movwf	OPTION_REG
	movlw	B'000000000'; digital inputs
	movwf	ANSEL
	movlw	B'01101000'	; 0110 for 4MHz
	movwf	OSCCON		; 
	bsf		PIE1,TMR1IE	; enable timer 1 interrupt
	bsf		INTCON,PEIE	; peripheral interrupt enable
	bcf		STATUS,RP0	; select memory bank 0
 	movlw	H'FB'		; preload timer 1
	movwf	TIMER1H_VAL
	movwf	TMR1H
	movlw	H'FF'
	movwf	TIMER1L_VAL
	movwf	TMR1L
	bcf		T1CON,5		; /1 prescaler
	bcf		T1CON,4
	bsf		T1CON,0		; timer 1 on	

; initial conditions

; clear registers to an invalid data value (?)
; TANK0 to TANK9			
; CELL0	to CELL9		
; TEMPC0 to TEMPC9		

	movlw	H'4A'		; start of register address
	movwf	FSR			; indirect register
	movlw	D'30'		; number of registers to clear
	movwf	TEMP
CLEAR_ALL; clear all to no data (ie set to 127 which is > data values of 100 maximim (bit 7 is - sign)
	movlw	H'7F' 
	movwf	INDF
	incf	FSR,f
	decfsz	TEMP,f		; next register	
	goto	CLEAR_ALL

; set timeouts for each tank for 1 hour
	movlw	H'76'		; start of timeout register address
	movwf	FSR			; indirect register
	movlw	D'10'		; number of registers 
	movwf	TEMP
SET_ALL; set all to 1 hour timeout
	movlw	D'55' 	
	movwf	INDF
	incf	FSR,f
	decfsz	TEMP,f		; next register	
	goto	SET_ALL
; set display mode
	movlw	EEPROM25	; mode storage
	call	EEREAD		; get value
	movwf	MODE		; display mode retreived
	movlw	D'1'
	movwf	TANK_SHOW	; tank No. 1
	clrf	SW_FLAG		; switch flag 

; initialise LCD
	call	INIT_LC	
	movlw	H'FF'		; start up delay
	call	DELAYX
	call	INIT_LC
	call	DELAYms
	call	INIT_LC
	call	DELAYms

	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX		; 
	movlw	B'00000110'	; entry mode. cursor moves right, display not shifted
	call	LOAD
	movlw	B'00001110'	; blinking off, cursor off
	call	LOAD
	movlw	B'00101100'	; display function (4-bits, 2 lines, 5x8 dots)
	call	LOAD		; 
	movlw	B'00000001'	; display clear
	call	LOAD
	movlw	H'FF'		; delay 
	call	DELAYX

; tank level bargraph generator
	call	CHARACTR_GEN;generate bar graph characters for tank level

; read tank selections
	
	movlw	EEPROM1		; tank 0-7 select
	call	EEREAD		; get value
	movwf	TANK_ON_OFF_A
	movlw	EEPROM2		; tank 8 & 9 select
	call	EEREAD		; get value
	movwf	TANK_ON_OFF_B

; read pump selections
	
	movlw	EEPROM3		; tank 0-7 select
	call	EEREAD		; get value
	movwf	PUMP_ON_OFF_A
	movlw	EEPROM4		; tank 8 & 9 select
	call	EEREAD		; get value
	movwf	PUMP_ON_OFF_B

; allow interrupts
ALL_INTERRUPTS
	bsf		STATUS,RP0	; select memory bank 1		
	bsf		PIE1,TMR1IE	; timer 1 overflow interrupt
	bcf		STATUS,RP0	; select memory bank 0
	bcf		PIR1,TMR1IF	; timer 1 interrupt flag
	bsf		INTCON,PEIE	; enable periperal interrupts 	 
	bsf 	INTCON,GIE	; set global interrupt enable 

	goto	DISPLAY_UPDATE; start by updating display

; check for a high at RA5
INPUT_SIG
	btfss	PORTA,5		; when high begin to read data
	goto	CHECK_SWITCHES
	clrf	FLAG		; 
	movlw	D'10'		; transmission counter
	movwf	TRANS_COUNT
TRANS_LOOP
	btfss	FLAG,0		; count flags (set in interrupt) for a 10ms transmission from tramnsitter 
	goto	TRANS_LOOP
	btfss	PORTA,5		; check if still high
	goto	INPUT_SIG	; not high so out
	decfsz	TRANS_COUNT,f; count
	goto	QUIETING_LOOP
	goto	LOCK_START
QUIETING_LOOP
	clrf	FLAG
	goto	TRANS_LOOP
	
LOCK_START
; use start bits to lock the transmission frequency

	bcf		INTCON,GIE	; stop interrupt
	bcf		T1CON,0		; stop timer 1
	clrf	TMR1L		; clear timer 1
	clrf	TMR1H
	clrf	FLAG		; interrupt occurred flag
	bcf		PIR1,TMR1IF	; clear interrupt flag
	clrf	TMR0		; timer 0 cleared plus prescaler
	nop
	nop
	nop					; wait for timer0 to clear	
	bcf		INTCON,TMR0IF; clear timer 0 flag
	movlw	D'56'
	movwf	COUNT_BITS	; number of bits of data
	
; count with timer 1 for RA5 to go low, high, low corresponding to a 0,1 start bits

WAIT_LOW
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_SWITCHES; IGNORE
	btfsc	PORTA,5		; wait till low 
	goto	WAIT_LOW

WAIT_HIGH
	btfsc	INTCON,TMR0IF; timer 0 overflow flag if timed out then ignore
	goto	CHECK_SWITCHES; IGNORE
	btfss	PORTA,5		; wait for a high 
	goto	WAIT_HIGH

; start of 16ms reference period from transmitter
	bsf		T1CON,0		; timer1 on to count and check for overrange
WAIT_LOW1
	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_SWITCHES; IGNORE
	btfsc	PORTA,5		; wait till low
	goto	WAIT_LOW1

; read timer 1 and divide by 16 to get the required timer 1 offset (take from FFFF to get preload value)
; if outside range then ignore. Typically should be 1024 but 2048 to 512 allowable

	btfsc	PIR1,TMR1IF	; timer 1 overflow flag if timed out then ignore
	goto	CHECK_SWITCHES; IGNORE
	bcf		T1CON,0		; stop timer 1
	movf	TMR1L,w		; read timer 1
	movwf	TIMER1L_WK	; working registers
	movf	TMR1H,w
	movwf	TIMER1H_WK

; divide by 16 to get average count between each edge
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /2
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /4
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /8
	bcf		STATUS,C
	rrf		TIMER1H_WK,f
	rrf		TIMER1L_WK,f	; /16

; compare with over range/under range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111110'		; 512 and greater
	btfsc	STATUS,Z		; if zero then value too small 
	goto	CHECK_SWITCHES	; value off range
	movf	TIMER1H_WK,w	; ms byte
	andlw	B'11111000'		; 2048 and greater
	btfss	STATUS,Z		; if not zero then value too large 
	goto	CHECK_SWITCHES	; IGNORE

; take from FFFF to get preset for interrupt rate	
	movf	TIMER1H_WK,w	; ms byte
	sublw	H'FF'			; maximum
	movwf	TIMER1H_VAL
	movf	TIMER1L_WK,w	; ls byte
	sublw	H'FF'			; maximum
	movwf	TIMER1L_VAL
	btfss	STATUS,C		; if carry reduce ms byte
	decf	TIMER1H_VAL,f

; add compensation for preload losses

	movlw	D'7'			; compensate for loss during preloading at interrupt
	addwf	TIMER1L_VAL,f	; add compensation
	btfsc	STATUS,C
	incf	TIMER1H_VAL,f	; if overrange increase ms byte

; preload counter 1 to sync with transmission rate 
	movf	TIMER1H_VAL,w
	movwf	TMR1H
	movf	TIMER1L_VAL,w
	movwf	TMR1L
	clrf	FLAG		; clear flag
	bsf		T1CON,0		; timer1 on start count	
	bsf		INTCON,GIE	; allow interrupts

; wait for one interrupt interval
WAIT_FLG_R
	btfss	FLAG,0
	goto	WAIT_FLG_R
	clrf	FLAG

; wait for 1/2 interrupt interval to centre measurement of level on high or low transmission

; calculate 1/2 interval
	bcf		STATUS,C	; carry cleared
	rrf		TIMER1H_WK,w	; divide by 2
	movwf	TIMER1H_2	; place in secondary register
	rrf		TIMER1L_WK,w
	movwf	TIMER1L_2
	
; take from FFFF to get shift in time to read data centred on a 1 or 0 value
	bcf		INTCON,GIE	; stop interrupts
	bcf		T1CON,0		; stop timer 1

	movf	TIMER1H_2,w	; ms byte
	sublw	H'FF'		; maximum
	movwf	TMR1H
	movf	TIMER1L_2,w	; ls byte
	sublw	H'FF'		; maximum
	movwf	TMR1L
	btfss	STATUS,C	; if carry reduce ms byte
	decf	TMR1H,f

	bcf		PIR1,TMR1IF	; clear interrupt flag
	bsf		T1CON,0		; run timer 1
	clrf	FLAG
	bsf		INTCON,GIE	; allow interrupts

; start of data
; shift into RECEIVE0,1,2,3,4,5
WAIT_FLG3
	btfss	FLAG,0		; wait for interrupt flag change
	goto	WAIT_FLG3

	clrf	FLAG		; clear interrupt flag
	bcf		STATUS,C	; clear carry 
	btfsc	PORTA,5		; check level
	bsf		STATUS,C	; set carry when portA,5 is set
	rlf		RECEIVEX,f	; stop bits value
	rlf		RECEIVE0,f	; temperature repeat
	rlf		RECEIVE1,f	; tank level %
	rlf		RECEIVE2,f	; cell volts 
	rlf		RECEIVE3,f	; temperature deg C
	rlf		RECEIVE4,f	; tank level %
	rlf		RECEIVE5,f 	; encode,tank number
	decfsz	COUNT_BITS,f
	goto	WAIT_FLG3	; continue loading bits
	
; check stop bits
	movf	RECEIVEX,w	; check if stops bits are correct
	xorlw	H'AA'		; must be AA for tank data
	btfss	STATUS,Z	; if status is zero value is correct
	goto	CHECK_SWITCHES 

; check encode (ms bits in RECEIVE5)
; encoded at rotary BCD switch (PORTB4-7) 
	clrf	ENCODE
	btfss	PORTB,6		; if clear set bit 4
	bsf		ENCODE,4	; ls bit of encode
	btfss	PORTB,4		; if clear set bit 5
	bsf		ENCODE,5	; mid bit of encode
	btfss	PORTB,5		; if clear set bit 6
	bsf		ENCODE,6	; mid bit of encode
	btfss	PORTB,7		; if clear set bit 7
	bsf		ENCODE,7	; ms bit of encode

; received encode must equal switch encode
	movf	RECEIVE5,w
	andlw	H'F0'		; ms bits only
	xorwf	ENCODE,w
	btfss	STATUS,Z
	goto	CHECK_SWITCHES

; check tank level data
	movf	RECEIVE1,w	; tank level
	xorwf	RECEIVE4,w	; second tank level register
	btfss	STATUS,Z	; if the same check if >110
	goto	CHECK_SWITCHES
	movf	RECEIVE1,w
	sublw	D'110'		; should not be >110
	btfss	STATUS,C
	goto	CHECK_SWITCHES

; temperature values sent should match
	movf	RECEIVE3,w	; temperature
	xorwf	RECEIVE0,w	; second temperature
	btfss	STATUS,Z	; if the same continue
	goto	CHECK_SWITCHES

; format tank number
	movf	RECEIVE5,w	; tank number
	andlw	H'0F'		; get ls bits	
	movwf	RECEIVE5	; reformat register for tank number	

; clear data timeout counter when data received		
	movlw	H'76'		; start address of tank No. counter 
	addwf	RECEIVE5,w	; tank number
	movwf	FSR			; add to FSR to get tank number address for level
	movlw	D'55'		; reset timer for 1 hour
	movwf	INDF		; write to FSR address

; get tank number to find address, write tank level to correct tank number address
	movlw	H'4A'		; start address of tank0 level value 
	addwf	RECEIVE5,w	; add to tank number
	movwf	FSR			; move to FSR to get tank number address for level
	movf	RECEIVE4,w	; tank level %
	movwf	INDF		; write to FSR address

; get tank number, write cell voltage to correct tank number
	movlw	H'54'		; start address of cell0 level 
	addwf	RECEIVE5,w	; add to tank number
	movwf	FSR			; move to FSR to get tank number address for level
	movf	RECEIVE2,w	; cell voltage 
	movwf	INDF		; write to FSR address

; get tank number, write temperature to correct tank number
	movlw	H'5E'		; start address of temperature level 
	addwf	RECEIVE5,w	; tank number
	movwf	FSR			; add to FSR to get tank number address for level
	movf	RECEIVE3,w	; temperature deg C
	movwf	INDF		; write to FSR address

; check if pump should be switched off for temperature and level
	movf	RECEIVE5,w	; tank number received
	call	CHK_LEVEL
	xorlw	D'00'		; w has result, if zero turn off pump
	btfss	STATUS,Z	;
	goto	DISPLAY_UPDATE	
	goto 	DRV_PUMP_OFF; and turn off pump if w is 0

; ***************************************************************************	
CHECK_SWITCHES
	bsf		INTCON,GIE	; if timed out restart interrupt
	bsf		T1CON,0		; timer1 on start count	
	btfsc	TIMEOUT_FLG,0; if timeout flag is set update display
	goto	DISPLAY_UPDATE
	btfsc	SW_FLAG,0	; if switch flag is set then add delay for change rate
	call	SW_DELAY	; switch delay	
	movlw	H'0F'		; lower bytes
	andwf	PORTB,w		; look at lower bits
	xorlw	H'0F'		; if all high no switch closed
	btfsc	STATUS,Z	; if zero no switch
	goto	INPUT_SIG
	call	DELAYms		; delay for debounce

; find closed switch
	btfsc	PORTB,1		; if clear then view switch	
	goto	SET_UP_DN	; select up or down switch
; View switch
	bsf		SW_FLAG,0	; set switch flag so a delay is incorporated
; if comming from set then clear MODE
	btfsc	MODE,7		; if set clear mode
	goto	ZERO_MODE	
	btfss	MODE,0		; toggle ls bit
	goto	SET_MODE0
ZERO_MODE
	clrf	MODE		; cleared
	goto	DISPLAY_UPDATE
SET_MODE0
	bsf		MODE,0		; set
	bcf		MODE,7		; clear set flag (bit 7)		
	goto	DISPLAY_UPDATE
SET_UP_DN
	btfsc	PORTB,0		; if clear, SET switch
	goto	UP_DN_SW
; SET switch
	bsf		SW_FLAG,0	; set switch flag so a delay is incorporated
; if going from view to set have ls mode bits cleared and set bit 7
	btfss	MODE,7		; if from view bit 7 will be clear
	goto	CLR_MODE1
	btfsc	OUT_FLAG,0	; if out flag is set clear mode to tank number setting
	goto	CLR_MODE1	; mode becomes H80
	incf	MODE,f		; next 
	btfsc	MODE,2		; when set clear to 0
CLR_MODE1
	clrf	MODE
	bsf		MODE,7		; sets SET mode flag
	goto	DISPLAY_UPDATE
UP_DN_SW ; check for up or down switch
	btfsc	PORTB,3		; if clear, up switch
	goto	DN_SW
; UP switch
	bsf		SW_FLAG,0	; set switch flag so a delay is incorporated 
; check modes
	btfsc	MODE,7		; if clear not in set mode 
	goto	LS_UP_MODE	; bit 7 set so set modes
; if bit 0 set increase tank number
	btfss	MODE,0	
	goto	INPUT_SIG

	incf	TANK_SHOW,w	; next tank
	sublw	D'9'		; if >9 do not increase
	btfss	STATUS,C
	goto	SET_0
	incf	TANK_SHOW,f	; increase to next tank
	bcf		DEC_FLAG,0	; increasing so DECrease flag cleared
	goto	DISPLAY_UPDATE
SET_0
	clrf	TANK_SHOW	; clear tank
	bcf		DEC_FLAG,0	; increasing so DECrease flag cleared
	goto	DISPLAY_UPDATE

LS_UP_MODE
; check ls mode bits
	btfsc	MODE,0		; if bit 0
	goto	UP_MODE_0
	btfsc	MODE,1		; bit 1
	goto	UP_MODE_1

; both MODE bits 0 and 1 are clear so increase tank_show value (0-9)
	incf	 TANK_SHOW,f; next tank
; check if 9 or more
	movlw	D'10'
	subwf	TANK_SHOW,w	; 
	btfsc	STATUS,C	; if carry is 1 then clear tank_show	
	clrf	TANK_SHOW
	goto	DISPLAY_UPDATE

; if MODE bit 0 set and 1 clear change pump off to on, on to off. Send an OFF signal to pump if set to off
; If set to on. Check level and temperature thresholds for a hold requirement. 
UP_MODE_0 ; bit 0 set
	btfss	MODE,1
	goto	PUMP_ON_OFF	
 	goto	SET_TEMP_UP
UP_MODE_1	; mode,1 set
	btfsc	MODE,0
	goto	SET_TEMP_UP
	
; bit 0 clear, level
SET_LEVEL_UP
; change value first 
	movlw	EEPROM5		; start of tank0 level settings EEPROM location
	addwf	TANK_SHOW,w ; tank shown added to get required location
	call	EEREAD		; get value
	movwf	TEMP		; temporary storage
	incf	TEMP,w		; next value
	sublw	D'99'		; if negative stop at 99
	btfsc	STATUS,C	; c is 0 if negative 
	incf	TEMP,f		; increase if not 99
	movf	TEMP,w
	call	EEWRITE		; write value
; test values with thresholds
TEST_VALUES
	call 	CHK_LEVELS
	xorlw	D'00'		; w has result, if zero turn off pump
	btfss	STATUS,Z	;
	goto	DISPLAY_UPDATE	
	goto 	SET_PUMP_OFF; and turn off pump if w is 0

; bit 0 set, temperature
SET_TEMP_UP
; change value first 
	movlw	EEPROM15	; start of tank0 temperature settings EEPROM location
	addwf	TANK_SHOW,w ; tank shown added to get required location
	call	EEREAD		; get value
	movwf	TEMP		; temporary storage
; if bit 7 clear then positive temperature
	btfsc	TEMP,7
	goto	NEG_INCREASE; increase negative temp from -9 to 0 	
	incf	TEMP,w		; next value
	sublw	D'99'		; if negative stop at 99
	btfsc	STATUS,C	; c is 0 if negative 
	incf	TEMP,f		; increase in not 99
	movf	TEMP,w
	call	EEWRITE		; write value
	goto	TEST_VALUES	; test values against thresholds
NEG_INCREASE
	decf	TEMP,w
	movwf	TEMP
	xorlw	H'80'		; if 80(ie from 81 to 80 (-1 to -0) then set to zero
	btfsc	STATUS,Z
	clrf	TEMP
	movf	TEMP,w
	call	EEWRITE		; write value
	goto	TEST_VALUES	; test values against thresholds

PUMP_ON_OFF ; switch pump on or off
	goto	SET_PUMP_ON_OFF
	
DN_SW
	btfsc	PORTB,2		; if clear, down switch
	goto	INPUT_SIG	; no switch pressed
; Down switch
	bsf		SW_FLAG,0	; set switch flag so a delay is incorporated

; check modes
	btfsc	MODE,7		; if clear not in set mode 
	goto	LS_DN_MODE	; bit 7 set so set modes
; if bit 0 set decrease tank number
	btfss	MODE,0	
	goto	INPUT_SIG
	movf	TANK_SHOW,w	
	btfsc	STATUS,Z	; if zero do not decrease but set at 9
	goto	SET_9
	decf	TANK_SHOW,f	; decrease to next tank
	bsf		DEC_FLAG,0	; decreasing so DECrease flag set
	goto	DISPLAY_UPDATE
SET_9
	movlw	D'9'
	movwf	TANK_SHOW
	bsf		DEC_FLAG,0	; decreasing so DECrease flag set
	goto	DISPLAY_UPDATE
	
LS_DN_MODE
; check ls mode bits
	btfsc	MODE,0		; if bit 0
	goto	DN_MODE_0
	btfsc	MODE,1		; bit 1
	goto	DN_MODE_1
	goto	ALTERN_TANK_ON_OFF; alternately switch tank on and off

DN_MODE_0	; mode,0 set
	btfss	MODE,1
	goto	UP_MODE_0	; if MODE bit 0 set and 1 clear. Go to the Up switch section 
	goto	SET_TEMP_DN

DN_MODE_1	; mode bit 1 set
	btfss	MODE,0
; bit 0 clear, level
	goto	SET_LEVEL_DN

; bit 0 set, temperature
SET_TEMP_DN ; change value  
	movlw	EEPROM15	; start of tank0 temperature settings EEPROM location
	addwf	TANK_SHOW,w ; tank shown added to get required location
	call	EEREAD		; get value
	movwf	TEMP		; temporary storage
; if bit 7 clear then positive temperature
	btfsc	TEMP,7
	goto	NEG_DECREASE; decrease negative temp from to -1 to -9 	
	movf	TEMP,w		; value
	btfsc	STATUS,Z	; if 0 set bit 7 and bit 1 for negative 1
	goto	LOAD_1
	decf	TEMP,f		; decrease
	movf	TEMP,w
	call	EEWRITE		; write value
	goto	TEST_VALUES	; test values against thresholds
LOAD_1
	movlw	H'81'		; -1
	call	EEWRITE		; write value
	goto	TEST_VALUES	; test values against thresholds
NEG_DECREASE
	incf	TEMP,w
	movwf	TEMP
	xorlw	H'8A'		; if 8A(ie from 89 to 8A (-9 to -10) then keep at -9
	btfsc	STATUS,Z
	decf	TEMP,f		; back to H89
	movf	TEMP,w
	call	EEWRITE		; write value
	goto	TEST_VALUES	; test values against thresholds

SET_LEVEL_DN ; change value  
	movlw	EEPROM5		; start of tank0 level settings EEPROM location
	addwf	TANK_SHOW,w ; tank shown added to get required location
	call	EEREAD		; get value
	movwf	TEMP		; temporary storage
	btfss	STATUS,Z	; if zero do not change
	decf	TEMP,f		; decrease value
	movf	TEMP,w
	call	EEWRITE		; write value
; test values with thresholds
	goto	TEST_VALUES

; ********************************************************
DISPLAY_UPDATE
; check mode and if different to stored value store new setting in EEPROM
	movlw	EEPROM25	
	call	EEREAD		; sets EEADR, value returned in w
	xorwf	MODE,w		; if the same bypass storage
	btfsc	STATUS,Z
	goto	CONT_DISP_UPDATE
; store new Mode value in EEPROM
	movf	MODE,w
	call	EEWRITE
CONT_DISP_UPDATE
	bcf		TIMEOUT_FLG,0; clear timeout flag (set if data not valid after 1hour of no new data)	
	btfsc	MODE,7		; if set then SET mode
	goto	SET_MODE
	movf	MODE,w		; mode	
	btfss	STATUS,Z	; if zero show standard bargraph
; if 1 show tank, percent level, temperature and battery and thresholds
	goto	TANK_STATUS

BARGRAPH		
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call	LEVEL_WORD	; write LEVEL

; drive display as a bargraph (only for selected tanks)
; TANK_ON_OFF_A selects tanks 0-7, TANK_ON_OFF_B selects tanks 8 & 9
; 8-level bargraph shows from 0, 12%, 25% to 100%
; tank 1
TANK1_LEV; tank 1
	btfss	TANK_ON_OFF_A,1	; if set then selected
	goto	TANK1_LEV_OFF
	movf	TANK1,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
CK_TANK1
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
	btfsc	TANK_ON_OFF_A,6	; tank 6 on
	goto	TANK2_LEV
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK2_LEV
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK2_LEV
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK2_LEV
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK2_LEV
	call	SPACE1
	goto	TANK2_LEV
TANK1_LEV_OFF
	call	SPACE1			; off or separation between 1-5 tanks
	goto	CK_TANK1	
TANK2_LEV; tank 2
	btfss	TANK_ON_OFF_A,2	; if set then selected
	goto	TANK2_LEV_OFF
	movf	TANK2,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
CK_TANK2
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
	btfsc	TANK_ON_OFF_A,6	; tank 6 on
	goto	TANK3_LEV
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK3_LEV
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK3_LEV
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK3_LEV
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK3_LEV
	call	SPACE1
	goto	TANK3_LEV
TANK2_LEV_OFF
	call	SPACE1
	goto	CK_TANK2
TANK3_LEV; tank 3
	btfss	TANK_ON_OFF_A,3	; if set then selected
	goto	TANK3_LEV_OFF
	movf	TANK3,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
CK_TANK3
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
	btfsc	TANK_ON_OFF_A,6	; tank 6 on
	goto	TANK4_LEV
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK4_LEV
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK4_LEV
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK4_LEV
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK4_LEV
	call	SPACE1			; extra space
	goto	TANK4_LEV
TANK3_LEV_OFF
	call	SPACE1
	goto	CK_TANK3
TANK4_LEV; tank 4
	btfss	TANK_ON_OFF_A,4	; if set then selected
	goto	TANK4_LEV_OFF
	movf	TANK4,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
CK_TANK4
	btfsc	TANK_ON_OFF_A,6	; tank 6 on
	goto	TANK5_LEV
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK5_LEV
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK5_LEV
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK5_LEV
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK5_LEV
	call	SPACE1
	goto	TANK5_LEV
TANK4_LEV_OFF
	call	SPACE1
	goto	CK_TANK4
TANK5_LEV; tank 5
	btfss	TANK_ON_OFF_A,5	; if set then selected
	goto	TANK5_LEV_OFF
	movf	TANK5,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
	goto	TANK6_LEV
TANK5_LEV_OFF
	call	SPACE1
TANK6_LEV; tank 6
	btfss	TANK_ON_OFF_A,6	; if set then selected
	goto	TANK6_LEV_OFF
	movf	TANK6,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
	goto	TANK7_LEV
TANK6_LEV_OFF
	call	SPACE1
TANK7_LEV; tank 7
	btfss	TANK_ON_OFF_A,7	; if set then selected
	goto	TANK7_LEV_OFF
	movf	TANK7,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
	goto	TANK8_LEV
TANK7_LEV_OFF
	call	SPACE1
TANK8_LEV; tank 8
	btfss	TANK_ON_OFF_B,0	; if set then selected
	goto	TANK8_LEV_OFF
	movf	TANK8,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
	goto	TANK9_LEV
TANK8_LEV_OFF
	call	SPACE1
TANK9_LEV; tank 9
	btfss	TANK_ON_OFF_B,1	; if set then selected
	goto	TANK9_LEV_OFF
	movf	TANK9,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
	goto	TANK0_LEV
TANK9_LEV_OFF
	call	SPACE1
TANK0_LEV; tank 0
	btfss	TANK_ON_OFF_A,0	; if set then selected
	goto	TANK0_LEV_OFF
	movf	TANK0,w
	movwf	TEMP			; store for bar_drv routine
	call	BAR_DRV			; find bargraph value
	call	DRV_LCD			; drive LCD
	goto	TANK_LEV_LINE2
TANK0_LEV_OFF
	call	SPACE1
TANK_LEV_LINE2

; line 2 	
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	TANK_WORD	; write TANK
	call	SPACE2

; display tank number if selected
	movlw	H'20'  			; space
	btfsc	TANK_ON_OFF_A,1	; if set then selected
	movlw	A'1'			; show 1
	call	DRV_LCD			; space or a 1
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
	btfsc	TANK_ON_OFF_A,6	; tank6 on
	goto	TANK2_SEL
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK2_SEL
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK2_SEL
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK2_SEL
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK2_SEL
	call	SPACE1
TANK2_SEL
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_A,2	; if set then selected
	movlw	A'2'			; show 2
	call	DRV_LCD			; space or a 2
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
	btfsc	TANK_ON_OFF_A,6	; tank6 on
	goto	TANK3_SEL
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK3_SEL
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK3_SEL
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK3_SEL
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK3_SEL
	call	SPACE1
TANK3_SEL
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_A,3	; if set then selected
	movlw	A'3'			; show 3
	call	DRV_LCD			; space or a 3
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
	btfsc	TANK_ON_OFF_A,6	; tank6 on
	goto	TANK4_SEL
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK4_SEL
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK4_SEL
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK4_SEL
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK4_SEL
	call	SPACE1
TANK4_SEL
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_A,4	; if set then selected
	movlw	A'4'			; show 4
	call	DRV_LCD			; space or a 4
; if tanks 6,7,8,9 or 0 selected then no space between consecutive tank level displays
	btfsc	TANK_ON_OFF_A,6	; tank6 on
	goto	TANK5_SEL
	btfsc	TANK_ON_OFF_A,7	; tank 7 on
	goto	TANK5_SEL
	btfsc	TANK_ON_OFF_A,0	; tank 0 on
	goto	TANK5_SEL
	btfsc	TANK_ON_OFF_B,0	; tank 8 on
	goto	TANK5_SEL
	btfsc	TANK_ON_OFF_B,1	; tank 9 on
	goto	TANK5_SEL
	call	SPACE1
TANK5_SEL
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_A,5	; if set then selected
	movlw	A'5'			; show 5
	call	DRV_LCD			; space or a 5
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_A,6	; if set then selected
	movlw	A'6'			; show 6
	call	DRV_LCD			; space or a 6
	movlw	H'20'  			; space
	btfsc	TANK_ON_OFF_A,7	; if set then selected
	movlw	A'7'			; show 7
	call	DRV_LCD			; space or a 7
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_B,0	; if set then selected
	movlw	A'8'			; show 8
	call	DRV_LCD			; space or a 8
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_B,1	; if set then selected
	movlw	A'9'			; show 9
	call	DRV_LCD			; space or a 9
	movlw	H'20'   		; space
	btfsc	TANK_ON_OFF_A,0	; if set then selected
	movlw	A'0'			; show 0
	call	DRV_LCD			; space or a 0
	goto	CHECK_SWITCHES

; ******************************************* 
TANK_STATUS ; MODE = 1, show each tank data
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
	call	TANK_WORD	; write TANK
	clrf	TANK_COUNT	; number of times that tank number is checked for selection
	goto	CK_TANK_X	; find selected tanks
	
SHOW_TANK
	movf	TANK_SHOW,w
	iorlw	H'30'		; ASCII version of the tank number
	call	DRV_LCD		; show tank number that is selected
	call	SPACE1
	call	LEVEL_WORD	; write level

; show tank level for selected tank
	movlw	H'4A'		; start of tank level value (TANK0)
	movwf	FSR			; indirect addressing
	movf	TANK_SHOW,w	; tank to show
	addwf	FSR,f		; get tank level address
	movf	INDF,w		; find value
	xorlw	H'7F'		; no data value
	btfsc	STATUS,Z	; if = no data yet
	goto	NO_LEVEL_DATA
	movf	INDF,w
	call	THREE_DIGITS; drives display with 3-digits
	goto	PERC_LEV
NO_LEVEL_DATA
	call	SPACE1
	movlw	A'?'
	call	DRV_LCD
	call	SPACE1
PERC_LEV
	movlw	A'%'		; percent symbol
	call	DRV_LCD
	
; line 2
	movlw	H'C0'		; address line 2 position 0
	call	LOAD
; show temperature
	movlw	H'5E'		; start of temperature registers (TEMPC0)
	movwf	FSR			; indirect addressing
	movf	TANK_SHOW,w	; tank to show
	addwf	FSR,f		; get tank level address
	movf	INDF,w		; find value
	xorlw	H'7F'		; no data value
	btfsc	STATUS,Z	; if = no data yet
	goto	NO_TEMP_DATA
	movf	INDF,w
	movwf	TEMP
	movlw	H'20'		; space
	btfsc	TEMP,7		; if set show minus sign
	movlw	A'-'		; minus sign 
	call	DRV_LCD
	movf	TEMP,w		; temperature value (includes - sign)
	call	TWO_DIGITS	; drives display with 2-digits
	goto	DEG_SYMBOL
NO_TEMP_DATA
	call	SPACE1
	movlw	A'?'
	call	DRV_LCD
	call	SPACE1

DEG_SYMBOL
	movlw	H'DF'		; degrees symbol
	call	DRV_LCD
	movlw	A'C'		; celcius
	call	DRV_LCD
	call 	SPACE1
; battery voltage
	movlw	A'C'		; Cell voltage
	call	DRV_LCD
	movlw	A'E'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD
	movlw	A'L'		; 
	call	DRV_LCD

	movlw	H'4A'		; start of tank level value (TANK0)
	movwf	FSR			; indirect addressing
	movf	TANK_SHOW,w	; tank to show
	addwf	FSR,f		; get tank level address
	movf	INDF,w		; find value
	xorlw	H'7F'		; no data value
	btfsc	STATUS,Z	; if = no data yet
	goto	NO_CELL_DATA

	movlw	H'54'		; start of cell voltage (CELL0)
	movwf	FSR			; indirect addressing
	movf	TANK_SHOW,w	; tank to show
	addwf	FSR,f		; get tank level address
	movf	INDF,w		; find value
	movwf	BIN_0		; binary value

; check if 1.15V or less if so write a small x in the space after CELL

	sublw	D'115'		; 1.15V
	btfss	STATUS,C
	goto	BY_X
	movlw	H'EB'		; small x in top left	
	call	DRV_LCD	
	goto	WRITE_CELL_VOLTS
BY_X
	call	SPACE1		; no x
WRITE_CELL_VOLTS
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD1Z
	call	SPACE1		; leading 0's to space
	goto	LOAD2Z
LOAD1Z
	movf	OUT1,w
	call	DRV_LCD
LOAD2Z
	movlw	A'.'		; decimal point
	call	DRV_LCD
	movf	OUT2,w
	call	DRV_LCD
	movf	OUT3,w
	call	DRV_LCD
	goto	VOLT_CELL
NO_CELL_DATA
	call	SPACE3
	movlw	A'?'
	call	DRV_LCD
	call	SPACE1
VOLT_CELL
	movlw	A'V'		; volt symbol
	call	DRV_LCD	
	goto	CHECK_SWITCHES

NIL_SELECT ; no tank selected
	bsf		PCLATH,3	; page 1
	goto	WRITE_ERR	; bank 1 writes ERROR on screen

SET_MODE ;(10000000 is tank in/out, 10000001 is pump on/off, 10000010 is set low level for pump off
		 ; 10000011 is set temperature for pump off)
	 
	movlw	H'80'		; address line 1 pos 0
	call	LOAD
; if mode is 10000000 then tank select brackets required	
	movf	MODE,w
	xorlw	B'10000000'	; tank on/off
	call	L_BRACKET_SPACE; left bracket or space	

	call	TANK_WORD	; write TANK

; tank number
	movf	TANK_SHOW,w	; current tank number
	addlw	H'30'		; ASCII
	call	DRV_LCD

; if mode is 10000000 then tank select brackets required	
	movf	MODE,w
	xorlw	B'10000000'	; tank on/off
	call	R_BRACKET_SPACE; right bracket or space	
	goto	TANK_SEL_SHOW	; check if tank selected (out if it is)

PUMP_SEL_BRACKET
; if mode is 10000001 then pump select brackets required	
	movf	MODE,w
	xorlw	B'10000001'	; pump on/off
	call	L_BRACKET_SPACE; left bracket or space
	goto	SHOW_PUMP_ON_OR_OFF; determine if pump is on or off and show on or off

BRACK_L_R
; if mode is 10000001 then pump select brackets required	
	movf	MODE,w
	xorlw	B'10000001'	; pump on/off
	call	R_BRACKET_SPACE; Right bracket or space
	call	SPACE2
; line 2
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	
; write	OFF @
	movlw	A'O'		; write, OFF @
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	call	SPACE1
	movlw	A'@'		; 
	call	DRV_LCD

; if mode is 10000010 then level select brackets required	
	movf	MODE,w
	xorlw	B'10000010'	; level set
	call	L_BRACKET_SPACE; left bracket or space

; display stop pump level (99% max)
	movlw	EEPROM5		; start of tank0 EEPROM stop level
	addwf	TANK_SHOW,w	; current tank showing on display
	call	EEREAD		; get stop level for the tank
	call	TWO_DIGITS	; drives display with 2-digits
	movlw	A'%'		; percent
	call	DRV_LCD

; if mode is 10000010 then level select brackets required	
	movf	MODE,w
	xorlw	B'10000010'	; level set
	call	R_BRACKET_SPACE; right bracket or space

; temperature level
; if mode is 10000011 then level select brackets required	
	movf	MODE,w
	xorlw	B'10000011'	; temperature set
	call	L_BRACKET_SPACE; left bracket or space

; display stop temperature (-9 to +99 degrees C)
	movlw	EEPROM15	; start of tank0 EEPROM temperture stop value
	addwf	TANK_SHOW,w	; current tank showing on display
	call	EEREAD		; get stop temperature for the tank
	movwf	TEMP		; storage
	btfss	TEMP,7		; if set show minus sign
	goto	BY_MINUS
	movlw	A'-'		; minus sign 
	call	DRV_LCD
	movf	TEMP,w
	movwf	BIN_0		; binary value
	bcf		BIN_0,7		; bit 7 cleared (-sign in degrees C)
	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT3,w
	call	DRV_LCD		; show ls bit
	goto	DEG_SYMBOL1
BY_MINUS
	movf	TEMP,w
	call	TWO_DIGITS	; drives display with 2-digits
DEG_SYMBOL1
	movlw	H'DF'		; degrees symbol
	call	DRV_LCD
	movlw	A'C'		; C
	call	DRV_LCD

; if mode is 10000011 then level select brackets required	
	movf	MODE,w
	xorlw	B'10000011'	; temperature set
	call	R_BRACKET_SPACE; right bracket or space
	goto	CHECK_SWITCHES

; xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

; Subroutines

; display routines

; Right bracket or space
R_BRACKET_SPACE
	btfss	STATUS,Z
	goto	NOT_SEL
	movlw	A'>'		; show bracket when selected
	goto	L_R_BRACKET
; Left bracket or space
L_BRACKET_SPACE
	btfss	STATUS,Z
	goto	NOT_SEL
	movlw	A'<'		; show bracket when selected
	goto	L_R_BRACKET
NOT_SEL
	movlw	H'20'		; space
L_R_BRACKET
	call	DRV_LCD	
	return

LEVEL_WORD; write LEVEL
	movlw	A'L'		; LEVEL
	call	DRV_LCD
	movlw	A'E'		; LEVEL
	call	DRV_LCD
	movlw	A'V'		; LEVEL
	call	DRV_LCD
	movlw	A'E'		; LEVEL
	call	DRV_LCD
	movlw	A'L'		; LEVEL
	call	DRV_LCD
	call	SPACE1
	return

TANK_WORD; write TANK
	movlw	A'T'		; TANK
	call	DRV_LCD
	movlw	A'A'		; TANK
	call	DRV_LCD
	movlw	A'N'		; TANK
	call	DRV_LCD
	movlw	A'K'		; TANK
	call	DRV_LCD
	return
	
THREE_DIGITS; drives display with 3-digits
	movwf	BIN_0		; binary value

	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT1,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD1
	call	SPACE1		; leading 0's to space
	movf	OUT2,w
	xorlw	H'30'		; is it zero
	btfss	STATUS,Z
	goto	LOAD2
	call	SPACE1		; leading 0's to space
	goto	LOAD3
LOAD1
	movf	OUT1,w
	call	DRV_LCD
LOAD2
	movf	OUT2,w
	call	DRV_LCD
LOAD3
	movf	OUT3,w
	call	DRV_LCD
	return

TWO_DIGITS; drives display with 2-digits
	movwf	BIN_0		; binary value
	bcf		BIN_0,7		; bit 7 cleared (-sign in degrees C)

	call	BCD_ASCII	; get bcd/ASCII value
	movf	OUT2,w		; ms value
	xorlw	H'30'		; check if 0
	btfss	STATUS,Z
	goto	LOAD11
	call	SPACE1		; leading 0 to space
	goto	SPACE22	
LOAD11
	movf	OUT2,w
	call	DRV_LCD
SPACE22
	movf	OUT3,w
	call	DRV_LCD
	return

; add space/spaces in display

SPACE4
	movlw	H'20'		; space
	call	DRV_LCD
SPACE3
	movlw	H'20'		; space
	call	DRV_LCD
SPACE2
	movlw	H'20'		; space
	call	DRV_LCD
SPACE1
	movlw	H'20'		; space
	call	DRV_LCD
	return

; switch delay
SW_DELAY 
	movlw	D'20'
	movwf	SW_FLAG
SW_LOOP
	call	DELAYms
	decfsz	SW_FLAG,f	; decrease til zero
	goto	SW_LOOP
	return

; delay loop 

DELAYms
	movlw	D'23'		; delay value
DELAYX
	movwf	STORE1		; STORE1 is number of loops value
LOOP8	
	movlw	H'B0'
DELDSP
	movwf	STORE2		; STORE2 is internal loop value	
LOOP9
	decfsz	STORE2,f
	goto	LOOP9
	decfsz	STORE1,f
	goto	LOOP8
	return

DELAY1
	movlw	D'2'		; delay value
DELAYXX
	movwf	STORE1		; STORE1 is number of loops value
LOOPA	
	movlw	D'165'
	movwf	STORE2		; STORE2 is internal loop value	
LOOPB
	decfsz	STORE2,f
	goto	LOOPB
	decfsz	STORE1,f
	goto	LOOPA		; decrease till STORE1 is zero
	return

; initialise display

INIT_LC
	movlw	B'00001001'	; DB4 and DB5 high (via RA0,RA3) to initialise module
	movwf	PORTA
	nop
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; low
	return

; preload display commands (4-bit) 

LOAD
	movwf	D_STO		; store data	
	movf	D_STO,w
	andlw	H'F0'		; get upper bits
; place ms bits of display commands in portA
	movwf	PORTA_STO
	clrf	PORTA		; data lines low	
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bcf		PORTA,6		; register select low
	nop
	bsf		PORTA,7		; enable set
	nop
	bcf		PORTA,7		; enable clear
	swapf	D_STO,w
	andlw	H'F0'		; get lower bits

; place ls 4-bits display commands in portA
	movwf	PORTA_STO
	clrf	PORTA
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bcf		PORTA,6		; register select low
	nop
	bsf		PORTA,7		; enable set
	nop
	bcf		PORTA,7		; enable clear
	goto	BUS_CK		; check busy flag
	
; driving the LCD module with display data

DRV_LCD	
	movwf	D_STO		; store data
	andlw	H'F0'		; upper bits
	movwf	PORTA_STO
	clrf	PORTA
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bsf		PORTA,6		; register select
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; enable low
	swapf	D_STO,w
	andlw	H'F0'		; lower bits
	movwf	PORTA_STO
	clrf	PORTA
	btfsc	PORTA_STO,7
	bsf		PORTA,1		; set data lines if required
	btfsc	PORTA_STO,6
	bsf		PORTA,2	
	btfsc	PORTA_STO,5
	bsf		PORTA,0	
	btfsc	PORTA_STO,4
	bsf		PORTA,3	
	bsf		PORTA,6		; register select
	bsf		PORTA,7		; enable high
	nop
	bcf		PORTA,7		; enable low

BUS_CK ; time for display to finish updating data
	movlw 	D'2'		; 
	movwf	STORE1		; delay values
	movlw	D'255'		; delay for busy flag to clear
	goto	DELDSP

; subroutine to read EEPROM memory 

EEREAD
	bcf		STATUS,RP0	; select bank 0
	bsf 	STATUS,RP1	; select memory bank 2
	movwf 	EEADR		; indirect special function register
	bsf 	STATUS,RP0	; select memory bank 3
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,RD	; read EEPROM
	bcf 	STATUS,RP0	; select memory bank 2
	movf	EEDATA,w	; EEPROM value in w
	bcf		STATUS,RP1	; select bank 0
	return

; subroutine to write to EEPROM
EWRITE
EEWRITE	
	bcf 	STATUS,RP0	; bank 0
	bsf		STATUS,RP1	; select bank 2
	movwf	EEDATA		; data register
	bsf 	STATUS,RP0	; select memory bank 3
WR3	
	btfsc	EECON1,WR	; check if write complete 
	goto 	WR3			; not written yet
	bcf		INTCON,GIE	; disable interrupts
	bcf		EECON1,EEPGD; data memory
	bsf		EECON1,WREN	; enable write
	movlw	H'55'		; place 55H in w for write sequence
	movwf 	EECON2 		; write 55H to EECON2
	movlw 	H'AA'		; AAH to w
	movwf	EECON2		; write AA to EECON2
	bsf		EECON1,WR	; set WR bit and begin write sequence
	bcf		EECON1,WREN	; clear WREN bit
	bsf 	INTCON,GIE	; enable interrupts
WRITE
	btfsc	EECON1,WR	; skip if write complete 
	goto 	WRITE		; not written yet
	bcf		EECON1,EEIF	; clear write interrupt flag
	bcf		STATUS,RP1	; 
	bcf 	STATUS,RP0	; select memory bank 0
	return				; value written 

; Subroutine to convert from 8-bit binary to 2-digit BCD (packed)
; Binary value is in BIN_0  
; Result in BCD is in BCD_0 & BCD_1.  
; BCD_0 is MSB, BCD_1 is LSB
; converts to unpacked ASCII in OUT1, OUT2, OUT3 (out1 is ms byte, out3 is ls byte)

BCD_ASCII
	bcf		STATUS,C	; clear carry bit
	movlw	D'8'
	movwf	CNT_8		; 8 in count
	clrf	BCD_0
	clrf	BCD_1		; set BCD registers to 0 
LOOPBCD
	rlf		BIN_0,f		; shift left binary registers
	rlf		BCD_1,f		; MSB shift left

	rlf		BCD_0,f		; LSB shift left BCD registers
	decfsz	CNT_8,f		; reduce count value return when 0
	goto	DECADJ		; continue decimal adjust

; completed decimal to BCD operation, convert to unpacked ASCII
	
	movf	BCD_1,w		; ls decimal
	andlw	H'0F'		; ls
	addlw	H'30'		; convert to ASCII
	movwf	OUT3
	swapf	BCD_1,w 	; mid decimal value
	andlw	H'0F'
	addlw	H'30'		; convert to ASCII
	movwf	OUT2
	movf	BCD_0,w
	addlw	H'30'		; convert to ASCII
	movwf	OUT1		; ms decimal value
	return				; ASCII values returned in OUT1, OUT2, OUT3 

; subroutine decimal adjust

DECADJ
	movlw	BCD_1		; BCD LSB address
	movwf	FSR			; pointer for BCD1
	call	ADJBCD		; subroutine to adjust BCD
	movlw	BCD_0		; BCD MS address
	movwf	FSR			; pointer for BCD0
	call	ADJBCD
	goto	LOOPBCD

; subroutine adjust BCD

ADJBCD	
	movlw	H'03'		; w has 03 
	addwf	INDF,w		; add 03 to BCDx register (x is 0-1)
	movwf	TEMP		; store w
	btfsc	TEMP,3		; test if >7
	movwf	INDF		; save as LS digit
	movlw	H'30'		; 3 for MSbyte
	addwf	INDF,w		; add 30 to BCDx register
	movwf	TEMP		; store w in temp
	btfsc	TEMP,7		; test if >7
	movwf	INDF		; save as MS digit
	return				; end subroutine

; get bargraph value
BAR_DRV
	movf	TEMP,w		; retreive value
	xorlw	H'7F'		; no data value
	btfsc	STATUS,Z	; if = no data yet
	retlw	A'?'		; return a ? for no data	
	movf	TEMP,w
	sublw	D'98'		; if 99% or more show 8-bars 	
	btfss	STATUS,C	; if c is 0 then show 8-bars
	retlw	H'FF'		; 8-bars
	movf	TEMP,w
	sublw	D'86'		; 87%
	btfss	STATUS,C
	retlw	D'6'		; 7-bars
	movf	TEMP,w
	sublw	D'74'		; 75%
	btfss	STATUS,C
	retlw	D'5'		; 6-bars
	movf	TEMP,w
	sublw	D'61'		; 62%
	btfss	STATUS,C
	retlw	D'4'		; 5-bars
	movf	TEMP,w
	sublw	D'49'		; 50%
	btfss	STATUS,C
	retlw	D'3'		; 4-bars
	movf	TEMP,w
	sublw	D'36'		; 37%
	btfss	STATUS,C
	retlw	D'2'		; 3-bars
	movf	TEMP,w
	sublw	D'24'		; 25%
	btfss	STATUS,C
	retlw	D'1'		; 2-bars
	movf	TEMP,w
	sublw	D'11'		; 12%
	btfss	STATUS,C
	retlw	D'0'		; 1-bar
	retlw	H'E3'		; < 12% Empty

; character generation 
CHARACTR_GEN
; Level 1 minimum tank level is an e

; level 2
; address 1, 1 bar
	movlw	B'01000000'	; address 0
	call	LOAD		; character gen 1 
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; level 3
; address 2, 2 bars
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; level 4
; address 3, 3 bars
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; level 5
; address 4, 4-bars
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; level 6
; address 5, 5-bars
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; level 7
; address 6, 6-bars
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
; level 8
; address 7, 7-bars
	movlw	B'00010001'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	movlw	B'00011111'
	call	DRV_LCD
	return
; level 9 is a full 8-bar graph H'FF' in character patterns

; **********************************************************************

SHOW_PUMP_ON_OR_OFF
; check if pump is on or off
; PUMP_ON_OFF_A	pump on or off (0 to 7)
; PUMP_ON_OFF_B	pump on or off (8 & 9)
	
; 0
	movf	TANK_SHOW,w
	xorlw	D'00'		; pump 0
	btfsc	STATUS,Z
	goto	PUMP_SHOW0	; pump0
; 1
	movf	TANK_SHOW,w
	xorlw	D'01'		; pump 1
	btfsc	STATUS,Z
	goto	PUMP_SHOW1	; pump1
; 2
	movf	TANK_SHOW,w
	xorlw	D'02'		; pump 2
	btfsc	STATUS,Z
	goto	PUMP_SHOW2	; pump2
; 3
	movf	TANK_SHOW,w
	xorlw	D'03'		; pump 3
	btfsc	STATUS,Z
	goto	PUMP_SHOW3	; pump3
; 4
	movf	TANK_SHOW,w
	xorlw	D'04'		; pump 4
	btfsc	STATUS,Z
	goto	PUMP_SHOW4	; pump4
; 5
	movf	TANK_SHOW,w
	xorlw	D'05'		; pump 5
	btfsc	STATUS,Z
	goto	PUMP_SHOW5	; pump5
; 6
	movf	TANK_SHOW,w
	xorlw	D'06'		; pump 6
	btfsc	STATUS,Z
	goto	PUMP_SHOW6	; pump6
; 7
	movf	TANK_SHOW,w
	xorlw	D'07'		; pump 7
	btfsc	STATUS,Z
	goto	PUMP_SHOW7	; pump7
; 8
	movf	TANK_SHOW,w
	xorlw	D'08'		; pump 8
	btfsc	STATUS,Z
	goto	PUMP_SHOW8	; pump8
; 9
	movf	TANK_SHOW,w
	xorlw	D'09'		; pump 9
	btfsc	STATUS,Z
	goto	PUMP_SHOW9	; pump9

PUMP_SHOW0
	btfss	PUMP_ON_OFF_A,0	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW1
	btfss	PUMP_ON_OFF_A,1	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW2
	btfss	PUMP_ON_OFF_A,2	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW3
	btfss	PUMP_ON_OFF_A,3	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW4
	btfss	PUMP_ON_OFF_A,4	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW5
	btfss	PUMP_ON_OFF_A,5	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW6
	btfss	PUMP_ON_OFF_A,6	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW7
	btfss	PUMP_ON_OFF_A,7	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW8
	btfss	PUMP_ON_OFF_B,0	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 
PUMP_SHOW9
	btfss	PUMP_ON_OFF_B,1	; if set pump is set to on
	goto	WRITE_OFF	; pump off
	goto	WRITE_ON	; 

WRITE_OFF
	movlw	A'O'		; write, OFF
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	movlw	A'F'		; 
	call	DRV_LCD
	goto	BRACK_L_R
WRITE_ON
	movlw	A'O'		; write, ON
	call	DRV_LCD
	movlw	A'N'		; 
	call	DRV_LCD
	goto	BRACK_L_R


; Check if tank is selected on or off 
; TANK_ON_OFF_A	tank on or off (0 to 7)
; TANK_ON_OFF_B	tank on or off (8 & 9)

TANK_SEL_SHOW
; 0
	movf	TANK_SHOW,w
	xorlw	D'00'		; tank 0
	btfsc	STATUS,Z
	goto	TANK_SHOW0	; tank0
; 1
	movf	TANK_SHOW,w
	xorlw	D'01'		; tank 1
	btfsc	STATUS,Z
	goto	TANK_SHOW1	; tank1
; 2
	movf	TANK_SHOW,w
	xorlw	D'02'		; tank 2
	btfsc	STATUS,Z
	goto	TANK_SHOW2	; tank2
; 3
	movf	TANK_SHOW,w
	xorlw	D'03'		; tank 3
	btfsc	STATUS,Z
	goto	TANK_SHOW3	; tank3
; 4
	movf	TANK_SHOW,w
	xorlw	D'04'		; tank 4
	btfsc	STATUS,Z
	goto	TANK_SHOW4	; tank4
; 5
	movf	TANK_SHOW,w
	xorlw	D'05'		; tank 5
	btfsc	STATUS,Z
	goto	TANK_SHOW5	; tank5
; 6
	movf	TANK_SHOW,w
	xorlw	D'06'		; tank 6
	btfsc	STATUS,Z
	goto	TANK_SHOW6	; tank6
; 7
	movf	TANK_SHOW,w
	xorlw	D'07'		; tank 7
	btfsc	STATUS,Z
	goto	TANK_SHOW7	; tank7
; 8
	movf	TANK_SHOW,w
	xorlw	D'08'		; tank 8
	btfsc	STATUS,Z
	goto	TANK_SHOW8	; tank8
; 9
	movf	TANK_SHOW,w
	xorlw	D'09'		; tank 9
	btfsc	STATUS,Z
	goto	TANK_SHOW9	; tank9

	clrf	TANK_SHOW	; if none of these clear for tank 0
	incf	TANK_SHOW,f	; tank 1
	goto	TANK_SHOW1 

TANK_SHOW0
	btfss	TANK_ON_OFF_A,0	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW1
	btfss	TANK_ON_OFF_A,1	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW2
	btfss	TANK_ON_OFF_A,2	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW3
	btfss	TANK_ON_OFF_A,3	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW4
	btfss	TANK_ON_OFF_A,4	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW5
	btfss	TANK_ON_OFF_A,5	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW6
	btfss	TANK_ON_OFF_A,6	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW7
	btfss	TANK_ON_OFF_A,7	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW8
	btfss	TANK_ON_OFF_B,0	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update
TANK_SHOW9
	btfss	TANK_ON_OFF_B,1	; if set tank is set to on
	goto	WRITE_OUT	; tank off
	goto	WRITE_PUMP	; continue with display update

WRITE_PUMP
	clrf	OUT_FLAG	; allows moving to pump,level and temp settings change
	movlw	A'P'		; write, PUMP
	call	DRV_LCD
	movlw	A'U'		; 
	call	DRV_LCD
	movlw	A'M'		; 
	call	DRV_LCD
	movlw	A'P'		; 
	call	DRV_LCD
	goto	PUMP_SEL_BRACKET

; tank out
WRITE_OUT ; tank out so no further display except OUT 
	clrf	MODE
	bsf		MODE,7		; keep at tank select mode
	bsf		OUT_FLAG,0	; out flag set
;	call	SPACE1
;	movlw	A'<'		; down switch to alter
;	call	DRV_LCD		
	movlw	A'O'		; write, OUT
	call	DRV_LCD
	movlw	A'U'		; 
	call	DRV_LCD
	movlw	A'T'		; 
	call	DRV_LCD
	call	SPACE4
	call	SPACE2
	movlw	H'C0'		; address line 2 pos 0
	call	LOAD
	call	SPACE4
	call	SPACE4
	call	SPACE4
	call 	SPACE4
	goto	CHECK_SWITCHES

; check selected tank
CK_TANK_X
CK_TANK_0
	movf	TANK_SHOW,w
	xorlw	D'0'		; tank 0
	btfss	STATUS,Z
	goto	CK_TANK_1
	btfsc	TANK_ON_OFF_A,0; tank to show, check if selected 
	goto	SHOW_TANK	; display tank number
NEXT_TANK

; if decreasing decrease tank.
	btfsc	DEC_FLAG,0	; if bit set decreasing so decrease in value
	goto	DEC_TANK_SHOW1
	incf	TANK_SHOW,f; next tank
; check if 9 or more
	movf	TANK_SHOW,w
	sublw	D'9'		; take from 9 
	btfsc	STATUS,C	; if carry is 1 then clear tank_show	
	goto	CK_TANK_X
	clrf	TANK_SHOW
	incf	TANK_COUNT,f
	btfss	TANK_COUNT,1; when bit 1 set exit as no tank is selected
	goto	CK_TANK_X
	goto	NIL_SELECT	; no tank selected
DEC_TANK_SHOW1
	movf	TANK_SHOW,w
	btfsc	STATUS,Z	; when zero set at 9
	goto	SET_AT_9
	decf	TANK_SHOW,f	
	goto	CK_TANK_X
SET_AT_9
	movlw	D'9'
	movwf	TANK_SHOW
	incf	TANK_COUNT,f
	btfss	TANK_COUNT,1; when bit 1 set exit as no tank is selected
	goto	CK_TANK_X
	goto	NIL_SELECT	; no tank selected

CK_TANK_1
	movf	TANK_SHOW,w	; tank to display (0-9)
	xorlw	D'1'		; if a 1 check if TANK_ON_OFF_A,1 is set (selected). If not increase TANK_SHOW
	btfss	STATUS,Z
	goto	CK_TANK_2
	btfsc	TANK_ON_OFF_A,1; tank to show is 1, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_2
	movf	TANK_SHOW,w
	xorlw	D'2'		; tank 2
	btfss	STATUS,Z
	goto	CK_TANK_3
	btfsc	TANK_ON_OFF_A,2; tank to show is 2, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_3
	movf	TANK_SHOW,w
	xorlw	D'3'		; tank 3
	btfss	STATUS,Z
	goto	CK_TANK_4
	btfsc	TANK_ON_OFF_A,3; tank to show is 3, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_4
	movf	TANK_SHOW,w
	xorlw	D'4'		; tank 4
	btfss	STATUS,Z
	goto	CK_TANK_5
	btfsc	TANK_ON_OFF_A,4; tank to show, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_5
	movf	TANK_SHOW,w
	xorlw	D'5'		; tank 5
	btfss	STATUS,Z
	goto	CK_TANK_6
	btfsc	TANK_ON_OFF_A,5; tank to show, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_6
	movf	TANK_SHOW,w
	xorlw	D'6'		; tank 6
	btfss	STATUS,Z
	goto	CK_TANK_7
	btfsc	TANK_ON_OFF_A,6; tank to show, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_7
	movf	TANK_SHOW,w
	xorlw	D'7'		; tank 7
	btfss	STATUS,Z
	goto	CK_TANK_8
	btfsc	TANK_ON_OFF_A,7; tank to show, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_8
	movf	TANK_SHOW,w
	xorlw	D'8'		; tank 8
	btfss	STATUS,Z
	goto	CK_TANK_9
	btfsc	TANK_ON_OFF_B,0; tank to show, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK
CK_TANK_9
	movf	TANK_SHOW,w
	xorlw	D'9'		; tank 9
	btfss	STATUS,Z
	goto	CK_TANK_0
	btfsc	TANK_ON_OFF_B,1; tank to show, check if selected 
	goto	SHOW_TANK	; display tank number
	goto	NEXT_TANK

ALTERN_TANK_ON_OFF
; Both MODE bits 0 and 1 are clear, so alternatively set tank off or on. If off send a pump off signal.
	movf	TANK_SHOW,w
	xorlw	D'0'		; if zero alter bit 0 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A0
	movf	TANK_SHOW,w
	xorlw	D'1'		; if zero alter bit 1 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A1
	movf	TANK_SHOW,w
	xorlw	D'2'		; if zero alter bit 2 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A2
	movf	TANK_SHOW,w
	xorlw	D'3'		; if zero alter bit 3 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A3
	movf	TANK_SHOW,w
	xorlw	D'4'		; if zero alter bit 4 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A4
	movf	TANK_SHOW,w
	xorlw	D'5'		; if zero alter bit 5 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A5
	movf	TANK_SHOW,w
	xorlw	D'6'		; if zero alter bit 6 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A6
	movf	TANK_SHOW,w
	xorlw	D'7'		; if zero alter bit 7 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALT_A7
	movf	TANK_SHOW,w
	xorlw	D'8'		; if zero alter bit 0 in TANK_ON_OFF_B
	btfsc	STATUS,Z	;
	goto	ALT_A8
	movf	TANK_SHOW,w
	xorlw	D'9'		; if zero alter bit 1 in TANK_ON_OFF_B
	btfsc	STATUS,Z	;
	goto	ALT_A9
	goto	DISPLAY_UPDATE
ALT_A0
; alter bit 0 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,0
	goto	TANK_ON_0
	bcf		TANK_ON_OFF_A,0	; tank off
	bcf		PUMP_ON_OFF_A,0	; tank off = pump off
	goto	WRITE_TANK_OFF
TANK_ON_0
	bsf		TANK_ON_OFF_A,0
	goto	WRITE_TANK_ON
ALT_A1
; alter bit 1 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,1
	goto	TANK_ON_1
	bcf		TANK_ON_OFF_A,1
	bcf		PUMP_ON_OFF_A,1
	goto	WRITE_TANK_OFF
TANK_ON_1
	bsf		TANK_ON_OFF_A,1
	goto	WRITE_TANK_ON
ALT_A2
; alter bit 2 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,2
	goto	TANK_ON_2
	bcf		TANK_ON_OFF_A,2
	bcf		PUMP_ON_OFF_A,2
	goto	WRITE_TANK_OFF
TANK_ON_2
	bsf		TANK_ON_OFF_A,2
	goto	WRITE_TANK_ON
ALT_A3
; alter bit 3 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,3
	goto	TANK_ON_3
	bcf		TANK_ON_OFF_A,3
	bcf		PUMP_ON_OFF_A,3
	goto	WRITE_TANK_OFF
TANK_ON_3
	bsf		TANK_ON_OFF_A,3
	goto	WRITE_TANK_ON
ALT_A4
; alter bit 4 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,4
	goto	TANK_ON_4
	bcf		TANK_ON_OFF_A,4
	bcf		PUMP_ON_OFF_A,4
	goto	WRITE_TANK_OFF
TANK_ON_4
	bsf		TANK_ON_OFF_A,4
	goto	WRITE_TANK_ON
ALT_A5
; alter bit 5 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,5
	goto	TANK_ON_5
	bcf		TANK_ON_OFF_A,5
	bcf		PUMP_ON_OFF_A,5
	goto	WRITE_TANK_OFF
TANK_ON_5
	bsf		TANK_ON_OFF_A,5
	goto	WRITE_TANK_ON
ALT_A6
; alter bit 6 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,6
	goto	TANK_ON_6
	bcf		TANK_ON_OFF_A,6
	bcf		PUMP_ON_OFF_A,6
	goto	WRITE_TANK_OFF
TANK_ON_6
	bsf		TANK_ON_OFF_A,6
	goto	WRITE_TANK_ON
ALT_A7
; alter bit 7 in TANK_ON_OFF_A
	btfss	TANK_ON_OFF_A,7
	goto	TANK_ON_7
	bcf		TANK_ON_OFF_A,7
	bcf		PUMP_ON_OFF_A,7
	goto	WRITE_TANK_OFF
TANK_ON_7
	bsf		TANK_ON_OFF_A,7
	goto	WRITE_TANK_ON
ALT_A8
; alter bit 0 in TANK_ON_OFF_B
	btfss	TANK_ON_OFF_B,0
	goto	TANK_ON_8
	bcf		TANK_ON_OFF_B,0
	bcf		PUMP_ON_OFF_B,0
	goto	WRITE_TANK_OFF
TANK_ON_8
	bsf		TANK_ON_OFF_B,0
	goto	WRITE_TANK_ON
ALT_A9
; alter bit 1 in TANK_ON_OFF_B
	btfss	TANK_ON_OFF_B,1
	goto	TANK_ON_9
	bcf		TANK_ON_OFF_B,1
	bcf		PUMP_ON_OFF_B,1
	goto	WRITE_TANK_OFF
TANK_ON_9
	bsf		TANK_ON_OFF_B,1
	goto	WRITE_TANK_ON

WRITE_TANK_OFF
	call	PUMP_OFF_TRANSMIT; send transmission code

WRITE_TANK_ON
WRITE_TANK
; write value to TANK EEPROM
	movlw	EEPROM1
	call	EEREAD		; sets EEADR
	movf	TANK_ON_OFF_A,w
	call	EEWRITE		; write to EEPROM
	movlw	EEPROM2
	call	EEREAD
	movf	TANK_ON_OFF_B,w
	call	EEWRITE
; write value to PUMP EEPROM
WRI_PMP
	movlw	EEPROM3
	call	EEREAD		; sets EEADR
	movf	PUMP_ON_OFF_A,w
	call	EEWRITE		; write to EEPROM
	movlw	EEPROM4
	call	EEREAD
	movf	PUMP_ON_OFF_B,w
	call	EEWRITE
	goto	DISPLAY_UPDATE

SET_PUMP_ON_OFF
	movf	TANK_SHOW,w
	xorlw	D'0'		; if zero alter bit 0 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A0
	movf	TANK_SHOW,w
	xorlw	D'1'		; if zero alter bit 1 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A1
	movf	TANK_SHOW,w
	xorlw	D'2'		; if zero alter bit 2 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A2
	movf	TANK_SHOW,w
	xorlw	D'3'		; if zero alter bit 3 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A3
	movf	TANK_SHOW,w
	xorlw	D'4'		; if zero alter bit 4 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A4
	movf	TANK_SHOW,w
	xorlw	D'5'		; if zero alter bit 5 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A5
	movf	TANK_SHOW,w
	xorlw	D'6'		; if zero alter bit 6 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A6
	movf	TANK_SHOW,w
	xorlw	D'7'		; if zero alter bit 7 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A7
	movf	TANK_SHOW,w
	xorlw	D'8'		; if zero alter bit 0 in TANK_ON_OFF_B
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A8
	movf	TANK_SHOW,w
	xorlw	D'9'		; if zero alter bit 1 in TANK_ON_OFF_B
	btfsc	STATUS,Z	;
	goto	ALTERNATE_A9
	goto	DISPLAY_UPDATE
ALTERNATE_A0
; alter bit 0 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,0
	goto	PUMP_ON_0
	bcf		PUMP_ON_OFF_A,0	; tank off
	goto	WRITE_PUMP_OFF
PUMP_ON_0
	bsf		PUMP_ON_OFF_A,0
	goto	WRITE_PUMP_ON
ALTERNATE_A1
; alter bit 1 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,1
	goto	PUMP_ON_1
	bcf		PUMP_ON_OFF_A,1
	goto	WRITE_PUMP_OFF
PUMP_ON_1
	bsf		PUMP_ON_OFF_A,1
	goto	WRITE_PUMP_ON
ALTERNATE_A2
; alter bit 2 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,2
	goto	PUMP_ON_2
	bcf		PUMP_ON_OFF_A,2
	goto	WRITE_PUMP_OFF
PUMP_ON_2
	bsf		PUMP_ON_OFF_A,2
	goto	WRITE_PUMP_ON
ALTERNATE_A3
; alter bit 3 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,3
	goto	PUMP_ON_3
	bcf		PUMP_ON_OFF_A,3
	goto	WRITE_PUMP_OFF
PUMP_ON_3
	bsf		PUMP_ON_OFF_A,3
	goto	WRITE_PUMP_ON
ALTERNATE_A4
; alter bit 4 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,4
	goto	PUMP_ON_4
	bcf		PUMP_ON_OFF_A,4
	goto	WRITE_PUMP_OFF
PUMP_ON_4
	bsf		PUMP_ON_OFF_A,4
	goto	WRITE_PUMP_ON
ALTERNATE_A5
; alter bit 5 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,5
	goto	PUMP_ON_5
	bcf		PUMP_ON_OFF_A,5
	goto	WRITE_PUMP_OFF
PUMP_ON_5
	bsf		PUMP_ON_OFF_A,5
	goto	WRITE_PUMP_ON
ALTERNATE_A6
; alter bit 6 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,6
	goto	PUMP_ON_6
	bcf		PUMP_ON_OFF_A,6
	goto	WRITE_PUMP_OFF
PUMP_ON_6
	bsf		PUMP_ON_OFF_A,6
	goto	WRITE_PUMP_ON
ALTERNATE_A7
; alter bit 7 in PUMP_ON_OFF_A
	btfss	PUMP_ON_OFF_A,7
	goto	PUMP_ON_7
	bcf		PUMP_ON_OFF_A,7
	goto	WRITE_PUMP_OFF
PUMP_ON_7
	bsf		PUMP_ON_OFF_A,7
	goto	WRITE_PUMP_ON
ALTERNATE_A8
; alter bit 0 in PUMP_ON_OFF_B
	btfss	PUMP_ON_OFF_B,0
	goto	PUMP_ON_8
	bcf		PUMP_ON_OFF_B,0
	goto	WRITE_PUMP_OFF
PUMP_ON_8
	bsf		PUMP_ON_OFF_B,0
	goto	WRITE_PUMP_ON
ALTERNATE_A9
; alter bit 1 in PUMP_ON_OFF_B
	btfss	PUMP_ON_OFF_B,1
	goto	PUMP_ON_9
	bcf		PUMP_ON_OFF_B,1
	goto	WRITE_PUMP_OFF
PUMP_ON_9
	bsf		PUMP_ON_OFF_B,1
	goto	WRITE_PUMP_ON

WRITE_PUMP_OFF
	call	PUMP_OFF_TRANSMIT; send off transmission code
	goto	WRI_PMP

WRITE_PUMP_ON
	call	CHK_LEVELS	; see if thresholds for level and temperature are ok. Send pump on signal
; if levels ok send pump on signal
	xorlw	D'00'		; if zero then no pump on
	btfss	STATUS,Z
	call	PUMP_ON_TRANSMIT; send on transmission code	
	goto	WRI_PMP		; write value to PUMP EEPROM

; SET PUMP OFF
SET_PUMP_OFF
	movf	TANK_SHOW,w
	xorlw	D'0'		; if zero alter bit 0 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,0	; pump off
	movf	TANK_SHOW,w
	xorlw	D'1'		; if zero alter bit 1 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,1	; pump off
	movf	TANK_SHOW,w
	xorlw	D'2'		; if zero alter bit 2 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,2	; pump off
	movf	TANK_SHOW,w
	xorlw	D'3'		; if zero alter bit 3 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,3	; pump off
	movf	TANK_SHOW,w
	xorlw	D'4'		; if zero alter bit 4 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,4	; pump off
	movf	TANK_SHOW,w
	xorlw	D'5'		; if zero alter bit 5 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,5	; pump off
	movf	TANK_SHOW,w
	xorlw	D'6'		; if zero alter bit 6 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,6	; pump off
	movf	TANK_SHOW,w
	xorlw	D'7'		; if zero alter bit 7 in TANK_ON_OFF_A
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_A,7	; pump off
	movf	TANK_SHOW,w
	xorlw	D'8'		; if zero alter bit 0 in TANK_ON_OFF_B
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_B,0	; pump off
	movf	TANK_SHOW,w
	xorlw	D'9'		; if zero alter bit 1 in TANK_ON_OFF_B
	btfsc	STATUS,Z	;
	bcf		PUMP_ON_OFF_B,1	; pump off

	call	PUMP_OFF_TRANSMIT; send off transmission code
	goto	WRI_PMP

; transmit pump off signal only if pump is selected on or tank is selected 
PUMP_OFF_TRANSMIT ; TANK_SHOW has current pump number to send code for
	movf	TANK_SHOW,w
PUMP_OFF_TRANSMIT1
	movwf	TEMP1	; TEMP has tank/pump number
	bsf		ONOFF,0	; pump set to OFF
	goto	TRANS_CONTINUE; continue transmission

; transmit on signal
PUMP_ON_TRANSMIT ; TANK_SHOW has current pump number to send code for
	movf	TANK_SHOW,w
	movwf	TEMP1
	bcf		ONOFF,0	; pump set to on
TRANS_CONTINUE
; Send Data

; start bits with gap for locking to data rate, encode value, tank number)
; onoff code in stop bits
; find encode
	clrf	TEMP		; initially clear
	btfss	PORTB,6		; set bits in TEMP if inputs are clear
	bsf		TEMP,4
	btfss	PORTB,4
	bsf		TEMP,5
	btfss	PORTB,5
	bsf		TEMP,6
	btfss	PORTB,7
	bsf		TEMP,7

	call	SW_DELAY	; delay between reception and transmission

SEND_DATA
; start bits with gap for locking to data rate, encode value (ENCODE_VAL), tank number (TANK_No,)

; send out a 1 to engage the receiver

	bsf		PORTA,4		; send a 1
	movlw	D'100'		; 50 ms
	call	DELAYXX		; ms
	bcf		PORTA,4		; send a zero
	movlw	D'10'		; 5 ms 
	call	DELAYXX		; ms

; send a reference gap

	bsf		PORTA,4		; a 1
	movlw	D'32'		; 16ms 
	call	DELAYXX		; extra length
	bcf		PORTA,4		; a 0		
	call	DELAY1

; start sending data
; encode
; 4-bits
	movf	TEMP,w		; send encode as ms nibble
; tank number
; 4-bits
	iorwf	TEMP1,w		; tank/pump number
	call	ROLL_8		; send out 
; pump off code
; 8-bits
	movlw	D'162'		; pump on
	btfsc	ONOFF,0		; if bit is clear, send an on signal, if bit is set an off
	movlw	D'150'		; send a pump off 
	call	ROLL_8
; stop bits
; 8-bits
	movlw	D'204'		; send stop bits (code for pump)
	call	ROLL_8
	bcf		PORTA,4		; output low
	return
	
; subroutines
; send out 8-bits
ROLL_8
	movwf	TEMP
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	rlf		TEMP,f
	call	SET_OUT
	return
SET_OUT
	btfss	STATUS,C	; if set send a 1
	goto	CLR_4
	bsf		PORTA,4
	call	DELAY1
	return
CLR_4	
	bcf		PORTA,4
	call	DELAY1
	return

; *****************************************************

CHK_LEVELS ; TANK_SHOW has current pump number to compare values with temperature and level
; TANK0 (H4A), TEMPC0 (H5E)(received tank level and temperature)
; compare with settings stored in EEPROM5, EEPROM15
; pump on if satisfactory temperature and level
	movf	TANK_SHOW,w	; shown tank number
CHK_LEVEL
	movwf	TANK_NUMBER	; store

; compare tank level to tank level setting
; if setting is < 50% then switch off pump below the setting (used for pump that supplies water from tank)
; if setting is > 50% then switch off pump above the setting (used for pump that supplies water to tank)
	movlw	EEPROM5		; start of tank0 level settings EEPROM location
	addwf	TANK_NUMBER,w ; tank shown added to get required location
	call	EEREAD		; get value
	movwf	TEMP		; temporary storage of setting
	
	movlw	H'4A'		; start of tank level (TANK0)
	addwf	TANK_NUMBER,w
	movwf	FSR			; indirect addressing

; is setting above or below 50%
	movf	TEMP,w		; setting
	sublw	D'50'
	btfss	STATUS,C
	goto	ABOVE_50
	
; below 50%
	movf	INDF,w		; tank level			
	subwf	TEMP,w		; take tank level from tank level setting
	btfss	STATUS,C	; if negative then tank level > than setting so satistactory
	goto	CK_TEMP		; see if temperature settings are ok
	retlw	D'00'		; set w at 00 for not satisfactory level

; above 50%
ABOVE_50
	movf	INDF,w		; tank level			
	subwf	TEMP,w		; take tank level from tank level setting
	btfsc	STATUS,C	; if negative then tank level < than setting so satistactory
	goto	CK_TEMP		; see if temperature settings are ok
	retlw	D'00'		; set w at 00 for not satisfactory level
	
CK_TEMP
	movlw	EEPROM15	; start of tank0 temperature settings EEPROM location
	addwf	TANK_NUMBER,w ; tank shown added to get required location
	call	EEREAD		; get value
	movwf	TEMP		; temporary storage of setting
	movlw	H'5E'		; start of temperature (TEMPC0)
	addwf	TANK_NUMBER,w
	movwf	FSR			; indirect addressing
	movf	INDF,w		; temperature		
	movwf	TEMP1		; store

; if temperature setting is - and temperature is plus, then satisfactory

	btfss	TEMP,7		; if setting is -
	goto	PLUS_TEMP
	btfss	TEMP1,7		; if +
	retlw	H'01'		; satisfatory
; if temperature setting is - and temperature is -
; compare the two - values
	movf	TEMP1,w
	subwf	TEMP,w
	btfss	STATUS,C
	retlw	D'00'		; values not satisfactory (do not switch on pump)
	retlw	D'01'		; values satisfactory	
PLUS_TEMP
; if temperature setting is 0 or more degrees (+)	
	btfsc	TEMP1,7		; and temperature is - then not satisfactory
	retlw	D'00'		; not satisfatory
; compare the two plus values
	movf	TEMP1,w
	subwf	TEMP,w
	btfsc	STATUS,C
	retlw	D'00'		; values not satisfactory (do not switch on pump)
	retlw	D'01'		; values satisfactory	

; switch off pump with reception of data
DRV_PUMP_OFF; and turn off pump if w is 0
	movf	RECEIVE5,w	; received tank data
	xorlw	D'0'		; if zero and bit 0 in TANK_ON_OFF_A is set send an off signal
	btfss	STATUS,Z	;
	goto	ONE_SEND_CHECK	; check tank 1
	btfss	PUMP_ON_OFF_A,0	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,0	; clear pump
	goto	DO_OFF			; do send an off signal
ONE_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'1'		; if one and bit 1 in TANK_ON_OFF_A is set send an off signal
	btfss	STATUS,Z	;
	goto	TWO_SEND_CHECK	; check tank 2
	btfss	PUMP_ON_OFF_A,1	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,1	; clear pump
	goto	DO_OFF			; do send an off signal
TWO_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'2'		; 
	btfss	STATUS,Z	;
	goto	THREE_SEND_CHECK; check tank 
	btfss	PUMP_ON_OFF_A,2	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,2	; clear pump
	goto	DO_OFF			; do send an off signal
THREE_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'3'		; 
	btfss	STATUS,Z	;
	goto	FOUR_SEND_CHECK; check tank 
	btfss	PUMP_ON_OFF_A,3	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,3	; clear pump
	goto	DO_OFF			; do send an off signal
FOUR_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'4'		; 
	btfss	STATUS,Z	;
	goto	FIVE_SEND_CHECK; check tank 
	btfss	PUMP_ON_OFF_A,4	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,4	; clear pump
	goto	DO_OFF			; do send an off signal
FIVE_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'5'		; 
	btfss	STATUS,Z	;
	goto	SIX_SEND_CHECK; check tank 
	btfss	PUMP_ON_OFF_A,5	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,5	; clear pump
	goto	DO_OFF			; do send an off signal
SIX_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'6'		; 
	btfss	STATUS,Z	;
	goto	SEVEN_SEND_CHECK; check tank 
	btfss	PUMP_ON_OFF_A,6	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,6	; clear pump
	goto	DO_OFF			; do send an off signal
SEVEN_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'7'		; 
	btfss	STATUS,Z	;
	goto	EIGHT_SEND_CHECK; check tank 
	btfss	PUMP_ON_OFF_A,7	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_A,7	; clear pump
	goto	DO_OFF			; do send an off signal
EIGHT_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'8'		; 
	btfss	STATUS,Z	;
	goto	NINE_SEND_CHECK; check tank 
	btfss	PUMP_ON_OFF_B,0	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_B,0	; clear pump
	goto	DO_OFF			; do send an off signal
NINE_SEND_CHECK
	movf	RECEIVE5,w	; received tank data
	xorlw	D'1'		; 
	btfss	STATUS,Z	;
	goto	NO_SEND_OFF	;  
	btfss	PUMP_ON_OFF_B,1	; pump on or off
	goto	NO_SEND_OFF		; tank off already
	bcf		PUMP_ON_OFF_B,1	; clear pump
;	goto	DO_OFF			; do send an off signal
	
DO_OFF ; store off value
	movlw	EEPROM3
	call	EEREAD		; sets EEADR
	movf	PUMP_ON_OFF_A,w
	call	EEWRITE		; write to EEPROM
	movlw	EEPROM4
	call	EEREAD
	movf	PUMP_ON_OFF_B,w
	call	EEWRITE
	movf	RECEIVE5,w		; receive 5 has tank number received
	call	PUMP_OFF_TRANSMIT1; send off signal	
NO_SEND_OFF
	goto	DISPLAY_UPDATE

	end
